﻿using System;
using PostitCore;
using PostitCommon;
using System.Collections.Generic;
using Newtonsoft.Json;
using System.Net.Http;

namespace DeXGets
{
    public class LearnerDietarys : BaseClass
    {
        public class LearnerDietarys_Response
        {
            public Guid ExternalID;
            public List<BaseLookups> DietaryNeeds;
            public List<DateRange> FreeMealEligibilityPeriods;
            public List<MealPattern> MealPatterns;
        }
        public class MealPattern
        {
            public Guid ExternalID;
            public Nullable<DateTime> StartDate;
            public Nullable<DateTime> EndDate;
            public List<MealPatternDiningSession> MealPatternDiningSessions;
        }
        public class MealPatternDiningSession
        {
            public Guid ExternalID;
            public string DayOfWeek;
            public BaseLookups MealType;

        }
        public class DateRange
        {
            public Guid ExternalID;
            public Nullable<DateTime> StartDate;
            public Nullable<DateTime> EndDate;
            public Nullable<bool> Protected;

        }
        /// <summary>
        /// Returns the set of contact contact basics
        /// </summary>
        /// <param name="token"></param>
        /// <param name="key"></param>
        /// <param name="httpClient"></param>
        /// <returns></returns>
        public Dictionary<Guid, LearnerDietarys_Response> GetValues(string token, string key, HttpClient httpClient)
        {
            Dictionary<Guid, LearnerDietarys_Response> values = new Dictionary<Guid, LearnerDietarys_Response>();
            string URL_LearnerDietary = SetURL("Learner", "LearnerDietarys?$expand=DietaryNeeds,FreeMealEligibilityPeriods,MealPatterns");
            string resp = DoCall(URL_LearnerDietary, token, httpClient, key);
            ODataResponse<LearnerDietarys_Response> learners = null;
            try
            {
                learners = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<LearnerDietarys_Response>>(resp);
                foreach (LearnerDietarys_Response s in learners.Value)
                {
                    values.Add(s.ExternalID, s);
                }
                // Very likely > 1000
                while (!string.IsNullOrEmpty(learners.NextLink))
                {
                    resp = DoCall(GetNextLink(learners.NextLink), token, httpClient, key);
                    learners = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<LearnerDietarys_Response>>(resp);
                    foreach (LearnerDietarys_Response s in learners.Value)
                    {
                        values.Add(s.ExternalID, s);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorMessage = "Error: " + resp;
            }
            return values;
        }
    }
}
